/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.client.AbstractTextKeyParsingClientLootTable;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClientChestLootTable
implements LootReceiver {
    public static ClientChestLootTable INSTANCE = new ClientChestLootTable();
    public final ResourceLocation id;
    public final Object2FloatMap<ItemStack> items;

    public ClientChestLootTable() {
        this.id = ResourceLocation.parse((String)"empty");
        this.items = new Object2FloatOpenHashMap();
    }

    public ClientChestLootTable(ResourceLocation id, Object2FloatMap<ItemStack> map) {
        this.id = id;
        this.items = map;
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public LootReceiver fromBuf(FriendlyByteBuf buf) {
        ResourceLocation id = AbstractTextKeyParsingClientLootTable.getIdFromBuf(buf);
        int mapCount = buf.readShort();
        Object2FloatOpenHashMap itemMap = new Object2FloatOpenHashMap();
        for (int i = 0; i < mapCount; ++i) {
            ItemStack item = this.readItemStack(buf);
            float itemWeight = buf.readFloat();
            if (item.is(Items.AIR)) continue;
            itemMap.put((Object)item, itemWeight);
        }
        return new ClientChestLootTable(id, (Object2FloatMap<ItemStack>)itemMap);
    }
}

